/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.network;

import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.placement.ComponentPlacement;
import com.technicalitiesmc.lib.circuit.placement.PlacementContext;
import com.technicalitiesmc.lib.network.Packet;
import com.technicalitiesmc.scm.block.CircuitBlock;
import com.technicalitiesmc.scm.circuit.server.ComponentInstance;
import com.technicalitiesmc.scm.circuit.server.ServerTileAccessor;
import com.technicalitiesmc.scm.init.SCMSoundEvents;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.network.NetworkEvent;

public class ComponentPlacePacket
implements Packet {
    private static final Capability<CircuitBlock.Data> DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CircuitBlock.Data>(){});
    private static final Capability<ComponentPlacement> COMPONENT_PLACEMENT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ComponentPlacement>(){});
    private final BlockPos pos;
    private final InteractionHand hand;
    private final byte[] placementData;

    public ComponentPlacePacket(BlockPos pos, InteractionHand hand, ComponentPlacement.Instance placement) {
        this.pos = pos;
        this.hand = hand;
        ByteBuf buf = Unpooled.buffer();
        placement.serialize(new FriendlyByteBuf(buf));
        this.placementData = Arrays.copyOf(buf.array(), buf.writerIndex());
        buf.release();
    }

    public ComponentPlacePacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        this.placementData = buf.m_130052_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.hand);
        buf.m_130087_(this.placementData);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerLevel level = context.getSender().m_183503_();
            BlockEntity entity = level.m_7702_(this.pos);
            if (entity == null) {
                return;
            }
            CircuitBlock.Data data = (CircuitBlock.Data)entity.getCapability(DATA_CAPABILITY).orElse(null);
            if (data == null) {
                return;
            }
            ItemStack item = context.getSender().m_21120_(this.hand);
            ComponentPlacement cap = (ComponentPlacement)item.getCapability(COMPONENT_PLACEMENT_CAPABILITY).orElse(null);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])this.placementData);
            ComponentPlacement.Instance placement = cap.deserialize(new FriendlyByteBuf(buf));
            buf.release();
            ServerTileAccessor accessor = data.getAccessor();
            placement.place((PlacementContext.Server)new SimpleServerContext((Player)context.getSender(), accessor, level, this.pos, item, context.getSender().m_7500_()));
        });
        return true;
    }

    private static class SimpleServerContext
    implements PlacementContext.Server {
        private final Player player;
        private final ServerTileAccessor accessor;
        private final ServerLevel level;
        private final BlockPos pos;
        private final ItemStack item;
        private final boolean isCreative;

        private SimpleServerContext(Player player, ServerTileAccessor accessor, ServerLevel level, BlockPos pos, ItemStack item, boolean isCreative) {
            this.player = player;
            this.accessor = accessor;
            this.level = level;
            this.pos = pos;
            this.item = item;
            this.isCreative = isCreative;
        }

        public Player getPlayer() {
            return this.player;
        }

        public boolean tryPut(Vec3i pos, ComponentType type, ComponentType.Factory factory) {
            return this.accessor.tryPut(pos, type, factory) != null;
        }

        public boolean tryPutAll(Predicate<PlacementContext.MultiPlacementContext> function) {
            ArrayList<Supplier> attempts = new ArrayList<Supplier>();
            boolean success = function.test((pos, type, factory) -> {
                Supplier<ComponentInstance> attempt = this.accessor.tryPutLater(pos, type, factory);
                if (attempt == null) {
                    return false;
                }
                attempts.add(attempt);
                return true;
            });
            if (!success || attempts.isEmpty()) {
                return false;
            }
            attempts.forEach(Supplier::get);
            return true;
        }

        public void consumeItems(int count) {
            if (!this.isCreative) {
                this.item.m_41774_(count);
            }
        }

        public void consumeItems(Item item, int count) {
            if (!this.isCreative) {
                Inventory inventory = this.player.m_150109_();
                ContainerHelper.m_18956_((Container)inventory, s -> s.m_150930_(item), (int)count, (boolean)false);
            }
        }

        public void playSound() {
            float pitch = 0.85f + (float)(Math.random() * 0.05);
            this.level.m_5594_(null, this.pos, (SoundEvent)SCMSoundEvents.COMPONENT_PLACE.get(), SoundSource.BLOCKS, 0.1f, pitch);
        }
    }
}

